/*******************************************************************************************************************
*
* Todo insert na tabela RC_CLI_FIDELI_PONTOS_DEBITO atualiza o saldo do cliente (tabela RC_CLI).
*
* Ultimo a modificar: Victor Vaz (25/01/2017)
*
*******************************************************************************************************************/

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_RC_CLI_FIDELI_PONTOS_DEBITO_ADD]'))
DROP TRIGGER [dbo].[TRG_RC_CLI_FIDELI_PONTOS_DEBITO_ADD]
GO
CREATE TRIGGER [dbo].[TRG_RC_CLI_FIDELI_PONTOS_DEBITO_ADD] ON [dbo].[RC_CLI_FIDELI_PONTOS_DEBITO]
FOR INSERT
AS
     BEGIN
         /* Update de informaes de pontos */
         UPDATE c
           SET
               QTDE_PONTOS = CASE
                                 WHEN i.QTDE_PONTOS > c.QTDE_PONTOS
                                 THEN 0																	--No devem haver pontos negativos
                                 ELSE ISNULL(c.QTDE_PONTOS, 0) - ISNULL(i.QTDE_PONTOS, 0)				--Pontos positivos
                             END
         FROM RC_CLI c
              INNER JOIN INSERTED i ON c.CD_EMP = i.CD_EMP
                                       AND c.CD_CLI = i.CD_CLI;
     END;
GO